/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.view;

import icyllis.modernui.ModernUI;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.drawable.Drawable;
import icyllis.modernui.math.Point;
import icyllis.modernui.view.DragData;
import icyllis.modernui.view.DragEvent;
import icyllis.modernui.view.MeasureSpec;
import icyllis.modernui.view.MotionEvent;
import icyllis.modernui.view.ViewGroup;
import icyllis.modernui.view.ViewParent;
import icyllis.modernui.view.ViewRootImpl;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class View {
    private static final AtomicInteger GENERATED_ID = new AtomicInteger(1);
    public static final Marker MARKER = MarkerManager.getMarker((String)"View");
    public static final int NO_ID = -1;
    static final int PFLAG_DRAWABLE_STATE_DIRTY = 1024;
    static final int PFLAG_MEASURED_DIMENSION_SET = 2048;
    static final int PFLAG_FORCE_LAYOUT = 4096;
    static final int PFLAG_LAYOUT_REQUIRED = 8192;
    static final int PFLAG_CANCEL_NEXT_UP_EVENT = 0x4000000;
    private static final int PFLAG_HOVERED = 0x10000000;
    int mPrivateFlags;
    public static final int VISIBLE = 0;
    public static final int INVISIBLE = 1;
    public static final int GONE = 2;
    static final int VISIBILITY_MASK = 3;
    static final int FOCUSABLE = 4;
    static final int ENABLED = 0;
    static final int DISABLED = 8;
    static final int ENABLED_MASK = 8;
    static final int SCROLLBARS_NONE = 0;
    static final int SCROLLBARS_HORIZONTAL = 32;
    static final int SCROLLBARS_VERTICAL = 64;
    static final int SCROLLBARS_MASK = 96;
    static final int CLICKABLE = 16384;
    int mViewFlags;
    private ViewParent mParent;
    ViewRootImpl viewRoot;
    int mId = -1;
    int mLeft;
    int mTop;
    int mRight;
    int mBottom;
    private int minWidth;
    private int minHeight;
    private int prevWidthMeasureSpec = Integer.MIN_VALUE;
    private int prevHeightMeasureSpec = Integer.MIN_VALUE;
    private int measuredWidth;
    private int measuredHeight;
    @Nullable
    private ScrollBar horizontalScrollBar;
    @Nullable
    private ScrollBar verticalScrollBar;
    private int[] mDrawableState = null;
    private ViewGroup.LayoutParams mLayoutParams;

    public void draw(@Nonnull Canvas canvas) {
        if ((this.mViewFlags & 3) == 0) {
            canvas.save();
            canvas.translate(this.mLeft, this.mTop);
            this.onDraw(canvas);
            this.dispatchDraw(canvas);
            if (this.verticalScrollBar != null) {
                this.verticalScrollBar.draw(canvas);
            }
            canvas.restore();
        }
    }

    protected void onDraw(@Nonnull Canvas canvas) {
    }

    protected void dispatchDraw(@Nonnull Canvas canvas) {
    }

    protected void tick(int ticks) {
    }

    public void layout(int left, int top, int right, int bottom) {
        boolean changed = this.setFrame(left, top, right, bottom);
        if (changed || (this.mPrivateFlags & 0x2000) != 0) {
            this.layoutScrollBars();
            this.onLayout(changed);
            this.mPrivateFlags &= 0xFFFFDFFF;
        }
        this.mPrivateFlags &= 0xFFFFEFFF;
    }

    private void layoutScrollBars() {
        int thickness;
        ScrollBar scrollBar = this.verticalScrollBar;
        if (scrollBar != null) {
            thickness = scrollBar.getSize();
            int r = this.mRight - scrollBar.getRightPadding();
            int l = Math.max(r - thickness, this.mLeft);
            int t = this.mTop + scrollBar.getTopPadding();
            int b = this.mBottom - scrollBar.getBottomPadding();
            scrollBar.setFrame(l, t, r, b);
        }
        if ((scrollBar = this.horizontalScrollBar) != null) {
            thickness = scrollBar.getSize();
            int b = this.mBottom - scrollBar.getBottomPadding();
            int t = Math.max(b - thickness, this.mTop);
            int l = this.mLeft + scrollBar.getLeftPadding();
            int r = this.mRight - scrollBar.getRightPadding();
            if (this.isVerticalScrollBarEnabled()) {
                r -= this.verticalScrollBar.getWidth();
            }
            scrollBar.setFrame(l, t, r, b);
        }
    }

    protected void onLayout(boolean changed) {
    }

    protected boolean setFrame(int l, int t, int r, int b) {
        if (this.mLeft != l || this.mRight != r || this.mTop != t || this.mBottom != b) {
            boolean sizeChanged;
            int oldWidth = this.getWidth();
            int oldHeight = this.getHeight();
            this.mLeft = l;
            this.mTop = t;
            this.mRight = r;
            this.mBottom = b;
            int newWidth = this.getWidth();
            int newHeight = this.getHeight();
            boolean bl = sizeChanged = newWidth != oldWidth || newHeight != oldHeight;
            if (sizeChanged) {
                this.onSizeChanged(newWidth, newHeight, oldWidth, oldHeight);
            }
            return true;
        }
        return false;
    }

    protected void onSizeChanged(int width, int height, int prevWidth, int prevHeight) {
    }

    public final void measure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean needsLayout;
        boolean bl = needsLayout = (this.mPrivateFlags & 0x1000) != 0;
        if (!needsLayout) {
            boolean specChanged = widthMeasureSpec != this.prevWidthMeasureSpec || heightMeasureSpec != this.prevHeightMeasureSpec;
            boolean isSpecExactly = MeasureSpec.getMode(widthMeasureSpec).isExactly() && MeasureSpec.getMode(heightMeasureSpec).isExactly();
            boolean matchesSpecSize = this.measuredWidth == MeasureSpec.getSize(widthMeasureSpec) && this.measuredHeight == MeasureSpec.getSize(heightMeasureSpec);
            boolean bl2 = needsLayout = specChanged && (!isSpecExactly || !matchesSpecSize);
        }
        if (needsLayout) {
            this.mPrivateFlags &= 0xFFFFF7FF;
            this.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if ((this.mPrivateFlags & 0x800) == 0) {
                throw new IllegalStateException("Measured dimension unspecified on measure");
            }
            this.mPrivateFlags |= 0x2000;
        }
        this.prevWidthMeasureSpec = widthMeasureSpec;
        this.prevHeightMeasureSpec = heightMeasureSpec;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.getDefaultSize(this.minWidth, widthMeasureSpec), View.getDefaultSize(this.minHeight, heightMeasureSpec));
    }

    protected final void setMeasuredDimension(int measuredWidth, int measuredHeight) {
        this.measuredWidth = measuredWidth;
        this.measuredHeight = measuredHeight;
        this.mPrivateFlags |= 0x800;
    }

    public final int getMeasuredWidth() {
        return this.measuredWidth;
    }

    public final int getMeasuredHeight() {
        return this.measuredHeight;
    }

    public ViewGroup.LayoutParams getLayoutParams() {
        return this.mLayoutParams;
    }

    public void setLayoutParams(@Nonnull ViewGroup.LayoutParams params) {
        this.mLayoutParams = params;
        this.requestLayout();
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public static int getDefaultSize(int size, int measureSpec) {
        switch (MeasureSpec.getMode(measureSpec)) {
            case UNSPECIFIED: {
                break;
            }
            case AT_MOST: 
            case EXACTLY: {
                return MeasureSpec.getSize(measureSpec);
            }
        }
        return size;
    }

    public static int resolveSize(int size, int measureSpec) {
        int result;
        int specSize = MeasureSpec.getSize(measureSpec);
        switch (MeasureSpec.getMode(measureSpec)) {
            case AT_MOST: {
                result = Math.min(specSize, size);
                break;
            }
            case EXACTLY: {
                result = specSize;
                break;
            }
            default: {
                result = size;
            }
        }
        return result;
    }

    @Nullable
    public final ViewParent getParent() {
        return this.mParent;
    }

    final void assignParent(@Nonnull ViewParent parent) {
        if (this.mParent != null) {
            throw new RuntimeException("Parent of view " + this + " has been assigned");
        }
        this.mParent = parent;
    }

    public int getId() {
        return this.mId;
    }

    public void setId(int id) {
        this.mId = id == -1 ? View.generateViewId() : id;
    }

    public static int generateViewId() {
        int next;
        int cur;
        do {
            if ((next = (cur = GENERATED_ID.get()) + 1) >= 1) continue;
            next = 1;
        } while (!GENERATED_ID.compareAndSet(cur, next));
        return cur;
    }

    void setStateFlag(int flag, int mask) {
        int old = this.mViewFlags;
        this.mViewFlags = this.mViewFlags & ~mask | flag & mask;
        int change = this.mViewFlags ^ old;
    }

    public void setVisibility(int visibility) {
        this.setStateFlag(visibility, 3);
    }

    public int getVisibility() {
        return this.mViewFlags & 3;
    }

    public boolean isEnabled() {
        return (this.mViewFlags & 8) == 0;
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.isEnabled()) {
            return;
        }
        this.setFlags(enabled ? 0 : 8, 8);
        this.refreshDrawableState();
        if (!enabled) {
            // empty if block
        }
    }

    public boolean isClickable() {
        return (this.mViewFlags & 0x4000) == 16384;
    }

    public void setClickable(boolean clickable) {
        this.setFlags(clickable ? 16384 : 0, 16384);
    }

    void setFlags(int flags, int mask) {
        int old = this.mViewFlags;
        this.mViewFlags = this.mViewFlags & ~mask | flags & mask;
    }

    public final void setHorizontalScrollBarEnabled(boolean enabled) {
        if (this.isHorizontalScrollBarEnabled() != enabled) {
            this.mViewFlags ^= 0x20;
        }
    }

    public final void setVerticalScrollBarEnabled(boolean enabled) {
        if (this.isVerticalScrollBarEnabled() != enabled) {
            this.mViewFlags ^= 0x40;
        }
    }

    public final boolean isHorizontalScrollBarEnabled() {
        return (this.mViewFlags & 0x20) != 0;
    }

    public final boolean isVerticalScrollBarEnabled() {
        return (this.mViewFlags & 0x40) != 0;
    }

    public final void setHorizontalScrollBar(@Nullable ScrollBar scrollBar) {
        if (this.horizontalScrollBar != scrollBar) {
            this.horizontalScrollBar = scrollBar;
        }
    }

    public final void setVerticalScrollBar(@Nullable ScrollBar scrollBar) {
        if (this.verticalScrollBar != scrollBar) {
            this.verticalScrollBar = scrollBar;
            if (scrollBar != null) {
                scrollBar.flags |= 0x20;
            }
        }
    }

    @Nullable
    public final ScrollBar getHorizontalScrollBar() {
        return this.horizontalScrollBar;
    }

    @Nullable
    public final ScrollBar getVerticalScrollBar() {
        return this.verticalScrollBar;
    }

    public final int getWidth() {
        return this.mRight - this.mLeft;
    }

    public final int getHeight() {
        return this.mBottom - this.mTop;
    }

    public final int getLeft() {
        return this.mLeft;
    }

    public final int getTop() {
        return this.mTop;
    }

    public final int getRight() {
        return this.mRight;
    }

    public final int getBottom() {
        return this.mBottom;
    }

    void dispatchAttachedToWindow(ViewRootImpl viewRoot) {
        this.viewRoot = viewRoot;
    }

    public void requestLayout() {
        boolean requestParent = (this.mPrivateFlags & 0x1000) == 0;
        this.mPrivateFlags |= 0x1000;
        if (requestParent && this.mParent != null) {
            this.mParent.requestLayout();
        }
    }

    public void forceLayout() {
        this.mPrivateFlags |= 0x1000;
    }

    public void refreshDrawableState() {
        this.mPrivateFlags |= 0x400;
        this.drawableStateChanged();
        ViewParent parent = this.mParent;
        if (parent != null) {
            parent.childDrawableStateChanged(this);
        }
    }

    protected void drawableStateChanged() {
    }

    public final int[] getDrawableState() {
        if (this.mDrawableState == null || (this.mPrivateFlags & 0x400) != 0) {
            this.mDrawableState = this.onCreateDrawableState(0);
            this.mPrivateFlags &= 0xFFFFFBFF;
        }
        return this.mDrawableState;
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        return new int[0];
    }

    public void getLocationInWindow(@Nonnull int[] location) {
        if (location.length < 2) {
            throw new IllegalArgumentException("Location array length must be two at least");
        }
        float x = this.mLeft;
        float y = this.mTop;
        for (ViewParent parent = this.mParent; parent != null; parent = parent.getParent()) {
            x -= parent.getScrollX();
            y -= parent.getScrollY();
        }
        location[0] = (int)x;
        location[1] = (int)y;
    }

    @Nullable
    public final <T extends View> T findViewById(int id) {
        if (id == -1) {
            return null;
        }
        return this.findViewTraversal(id);
    }

    @Nullable
    <T extends View> T findViewTraversal(int id) {
        if (id == this.mId) {
            return (T)this;
        }
        return null;
    }

    public final boolean startDragAndDrop(@Nullable DragData data, @Nullable DragShadow shadow, int flags) {
        if (this.viewRoot == null) {
            ModernUI.LOGGER.error(MARKER, "startDragAndDrop called out of a window");
            return false;
        }
        return this.viewRoot.startDragAndDrop(this, data, shadow, flags);
    }

    public boolean onDragEvent(DragEvent event) {
        return true;
    }

    public final boolean dispatchPointerEvent(MotionEvent event) {
        if (event.isTouchEvent()) {
            return this.dispatchTouchEvent(event);
        }
        return this.dispatchGenericMotionEvent(event);
    }

    public boolean dispatchGenericMotionEvent(MotionEvent event) {
        int action = event.getAction();
        if ((action == 9 || action == 7 || action == 10) && this.dispatchHoverEvent(event)) {
            return true;
        }
        if (this.dispatchGenericPointerEvent(event)) {
            return true;
        }
        return this.dispatchGenericMotionEventInternal(event);
    }

    private boolean dispatchGenericMotionEventInternal(MotionEvent event) {
        if (this.onGenericMotionEvent(event)) {
            return true;
        }
        if ((this.mViewFlags & 8) == 8) {
            return false;
        }
        int action = event.getAction();
        return false;
    }

    protected boolean dispatchHoverEvent(MotionEvent event) {
        return this.onHoverEvent(event);
    }

    protected boolean dispatchGenericPointerEvent(MotionEvent event) {
        return false;
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        return false;
    }

    public boolean onHoverEvent(MotionEvent event) {
        int action = event.getAction();
        if (this.isHoverable() || this.isHovered()) {
            switch (action) {
                case 9: {
                    this.setHovered(true);
                    break;
                }
                case 10: {
                    this.setHovered(false);
                }
            }
            this.dispatchGenericMotionEventInternal(event);
            return true;
        }
        return false;
    }

    private boolean isHoverable() {
        int viewFlags = this.mViewFlags;
        if ((viewFlags & 8) == 8) {
            return false;
        }
        return (viewFlags & 0x4000) == 16384;
    }

    public boolean isHovered() {
        return (this.mPrivateFlags & 0x10000000) != 0;
    }

    public void setHovered(boolean hovered) {
        if (hovered) {
            if ((this.mPrivateFlags & 0x10000000) == 0) {
                this.mPrivateFlags |= 0x10000000;
                this.refreshDrawableState();
                this.onHoverChanged(true);
            }
        } else if ((this.mPrivateFlags & 0x10000000) != 0) {
            this.mPrivateFlags &= 0xEFFFFFFF;
            this.refreshDrawableState();
            this.onHoverChanged(false);
        }
    }

    public void onHoverChanged(boolean hovered) {
    }

    protected boolean canReceivePointerEvents() {
        return (this.mViewFlags & 3) == 0;
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        boolean handled = false;
        int actionMasked = event.getActionMasked();
        if (this.onTouchEvent(event)) {
            handled = true;
        }
        return handled;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return false;
    }

    boolean isOnScrollbarThumb(float x, float y) {
        return false;
    }

    final boolean pointInView(float localX, float localY) {
        return this.pointInView(localX, localY, 0.0f);
    }

    boolean pointInView(float localX, float localY, float slop) {
        return localX >= -slop && localY >= -slop && localX < (float)(this.mRight - this.mLeft) + slop && localY < (float)(this.mBottom - this.mTop) + slop;
    }

    protected boolean onMousePressed(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    protected boolean onMouseReleased(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    protected boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    protected boolean onMouseDoubleClicked(double mouseX, double mouseY) {
        return false;
    }

    protected boolean onMouseScrolled(double mouseX, double mouseY, double amount) {
        return false;
    }

    protected void onStartDragging() {
    }

    protected void onStopDragging() {
    }

    protected boolean onMouseDragged(double mouseX, double mouseY, double deltaX, double deltaY) {
        return false;
    }

    protected void onStartKeyboard() {
    }

    protected void onStopKeyboard() {
    }

    protected boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    protected boolean onKeyReleased(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    protected boolean onCharTyped(char codePoint, int modifiers) {
        return false;
    }

    protected void onScrollBarClicked(boolean vertical, float scrollDelta) {
    }

    protected void onScrollBarDragged(boolean vertical, float scrollDelta) {
    }

    @FunctionalInterface
    public static interface OnHoverListener {
        public void onHover(View var1, MotionEvent var2);
    }

    public static class DragShadow {
        private final WeakReference<View> viewRef;

        public DragShadow(View view) {
            this.viewRef = new WeakReference<View>(view);
        }

        public DragShadow() {
            this.viewRef = new WeakReference<Object>(null);
        }

        @Nullable
        public final View getView() {
            return (View)this.viewRef.get();
        }

        public void onProvideShadowCenter(@Nonnull Point outShadowCenter) {
        }

        public void onDrawShadow(@Nonnull Canvas canvas) {
            View view = (View)this.viewRef.get();
            if (view != null) {
                view.onDraw(canvas);
            } else {
                ModernUI.LOGGER.error(MARKER, "No view found on draw shadow");
            }
        }
    }

    public class ScrollBar {
        private static final int DRAW_TRACK = 1;
        private static final int DRAW_THUMB = 2;
        private static final int ALWAYS_DRAW_TRACK = 4;
        private static final int TRACK_HOVERED = 8;
        private static final int THUMB_HOVERED = 16;
        private static final int VERTICAL = 32;
        @Nullable
        private Drawable track;
        private Drawable thumb;
        public int flags;
        private float thumbOffset;
        private float scrollRange;
        private int left;
        private int top;
        private int right;
        private int bottom;
        private int altSize = 5;
        private int padding;

        private void draw(@Nonnull Canvas canvas) {
            if ((this.flags & 1) != 0 && this.track != null) {
                this.track.draw(canvas);
            }
            if ((this.flags & 2) != 0) {
                canvas.save();
                if (this.isVertical()) {
                    canvas.translate(0.0f, this.thumbOffset);
                } else {
                    canvas.translate(this.thumbOffset, 0.0f);
                }
                this.thumb.draw(canvas);
                canvas.restore();
            }
        }

        public void setParameters(float range, float offset, float extent) {
            int thickness;
            int totalLength;
            boolean drawThumb;
            boolean drawTrack;
            boolean vertical = this.isVertical();
            if (extent <= 0.0f || range <= 0.0f) {
                drawTrack = (this.flags & 4) != 0;
                drawThumb = false;
            } else {
                drawThumb = true;
                drawTrack = true;
            }
            if (this.track != null) {
                this.track.setBounds(this.left, this.top, this.right, this.bottom);
            }
            if (vertical) {
                totalLength = this.getHeight();
                thickness = this.getWidth();
            } else {
                totalLength = this.getWidth();
                thickness = this.getHeight();
            }
            float preciseLength = (float)totalLength * extent / (range + extent);
            float preciseOffset = ((float)totalLength - preciseLength) * offset / range;
            int thumbLength = Math.round(Math.max(preciseLength, (float)(thickness << 1)));
            this.thumbOffset = Math.min(preciseOffset, (float)(totalLength - thumbLength));
            this.scrollRange = range;
            if (drawThumb) {
                if (vertical) {
                    this.thumb.setBounds(this.left, this.top, this.right, this.top + thumbLength);
                } else {
                    this.thumb.setBounds(this.left, this.top, this.left + thumbLength, this.bottom);
                }
            }
            this.flags = drawTrack ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
            this.flags = drawThumb ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        }

        public void setTrackDrawable(@Nullable Drawable track) {
            this.track = track;
        }

        public void setThumbDrawable(@Nonnull Drawable thumb) {
            this.thumb = thumb;
        }

        public boolean isAlwaysDrawTrack() {
            return (this.flags & 4) != 0;
        }

        public void setAlwaysDrawTrack(boolean alwaysDrawTrack) {
            this.flags = alwaysDrawTrack ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
        }

        public void setAlternativeSize(int alternativeSize) {
            this.altSize = alternativeSize;
        }

        public void setPadding(int left, int top, int right, int bottom) {
            this.padding = left | top << 8 | right << 16 | bottom << 24;
        }

        public int getLeftPadding() {
            return this.padding & 0xFF;
        }

        public int getTopPadding() {
            return this.padding >> 8 & 0xFF;
        }

        public int getRightPadding() {
            return this.padding >> 16 & 0xFF;
        }

        public int getBottomPadding() {
            return this.padding >> 24 & 0xFF;
        }

        private int getSize() {
            int s2 = this.isVertical() ? (this.track != null ? this.track.getIntrinsicWidth() : this.thumb.getIntrinsicWidth()) : (this.track != null ? this.track.getIntrinsicHeight() : this.thumb.getIntrinsicHeight());
            if (s2 <= 0) {
                return this.altSize;
            }
            return s2;
        }

        private boolean isVertical() {
            return (this.flags & 0x20) != 0;
        }

        private int getThumbLength() {
            if (this.isVertical()) {
                return this.thumb.getHeight();
            }
            return this.thumb.getWidth();
        }

        private void setFrame(int l, int t, int r, int b) {
            this.left = l;
            this.top = t;
            this.right = r;
            this.bottom = b;
        }

        private boolean updateMouseHover(double mouseX, double mouseY) {
            if (mouseX >= (double)this.left && mouseX < (double)this.right && mouseY >= (double)this.top && mouseY < (double)this.bottom) {
                this.flags |= 8;
                return true;
            }
            this.flags &= 0xFFFFFFF7;
            return false;
        }

        private boolean isThumbHovered() {
            return (this.flags & 0x10) != 0;
        }

        private boolean isTrackHovered() {
            return (this.flags & 8) != 0;
        }

        private int getWidth() {
            return this.right - this.left;
        }

        private int getHeight() {
            return this.bottom - this.top;
        }

        private boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
            if (this.isTrackHovered()) {
                if (this.isVertical()) {
                    float start = (float)this.top + this.thumbOffset;
                    float end = start + (float)this.getThumbLength();
                    if (mouseY < (double)start) {
                        float delta = this.toScrollDelta((float)(mouseY - (double)start - 1.0), true);
                        View.this.onScrollBarClicked(true, Math.max(-60.0f, delta));
                        return true;
                    }
                    if (mouseY > (double)end) {
                        float delta = this.toScrollDelta((float)(mouseY - (double)end + 1.0), true);
                        View.this.onScrollBarClicked(true, Math.min(60.0f, delta));
                        return true;
                    }
                } else {
                    float start = (float)this.left + this.thumbOffset;
                    float end = start + (float)this.getThumbLength();
                    if (mouseX < (double)start) {
                        float delta = this.toScrollDelta((float)(mouseX - (double)start - 1.0), false);
                        View.this.onScrollBarClicked(false, Math.max(-60.0f, delta));
                        return true;
                    }
                    if (mouseX > (double)end) {
                        float delta = this.toScrollDelta((float)(mouseX - (double)end + 1.0), false);
                        View.this.onScrollBarClicked(false, Math.min(60.0f, delta));
                        return true;
                    }
                }
            }
            return false;
        }

        private float toScrollDelta(float delta, boolean vertical) {
            delta *= this.scrollRange;
            if (vertical) {
                return delta / (float)(this.getHeight() - this.getThumbLength());
            }
            return delta / (float)(this.getWidth() - this.getThumbLength());
        }
    }
}

